# 第一章 开源的基本概念

## 1.1 开源的定义和特征

### 1.1.1 开源的定义

开源（Open Source）—词于1998年2月3日由Chris Peterson提出，“Open Source”的概念出自当时著名的黑客（Hacker）社区Debian的社长Bruce Perens起草的“ Debian Free Software Guidelines”（DFSG）。

1998年2月下旬，Eric Raymond和Bruce Perens共同创立"Open Source Initiative"（OSI）。OSI承担的首要任务之一是起草开源定义（OSD），并使用它来开始创建OSI批准的许可证列表。

对确立“Open Source”定义有决定意义的是在1998年4月7日在美国加州Palo Alto由18位“自由软件运动领袖”召开的Freeware高层会议，通过了传播开源的必要性。会议由Tim O'Reilly主持，Brain Behlendorf（Apache创始人）、Linus Torvalds（Linux创始人）、Guido van Rossum（Python创始人）、Eric Raymond（著名记者、OSI首届主席）等参加。

随着时代的变迁，开源的定义内涵也在不断演进。目前的共识是：开源是促进信息技术创新的重要途径，是将源代码、设计文档或其他创作内容开放共享的一种技术开发和发行模式。技术领域的开源包含源代码+软硬件设计文档源代码、源数据等技术和资源的开放共享，源代码仍然是开源的主要内容。 在开源模式下，通过许可证的方式，使用者在遵守许可限制的条件下，可自由获取源代码等，并可使用、复制、修改和再发布。

本质上，开源模式是一种依托互联网平台，大规模群体智慧通过共同参与和协作，不断累积智慧，实现持续创新的方法。该方法中，项目的核心开发人员与大规模的外围群体紧密合作，他们通过互联网来共享资源、开展协同开发、管理代码等，由此使得项目开发的效率、应对需求变化的能力大幅提升。

人们常常使用“自由开源软件”这个统一概念：FLOSS（Free/Libre Open Source Software），但开源与自由软件（见图1）是从两个角度看待同一事物，开源侧重于技术层面，自由软件侧重于被许可的权利。人们在开发软件时，欲利用、移植或剪裁现有的开源、自由软件资源，这是允许的，但有一个制约条件，即人们不能违背开源、自由软件许可证的规定，中断或破坏被应用、移植或剪裁的开源、自由软件自由传播的特征（在自由传播时，自由软件许可证比开源许可证的规定更为严酷），也就是说，人们不可侵犯开源、自由软件的知识产权。

![](https://img-blog.csdnimg.cn/3b5b60cdc1f948c2ab1afc5b8da2d350.png)
<br/>*图1 开源许可证与自由软件许可证的区别*

今天，开源的发展比自由软件的发展更接地气、更蓬勃，普及度也更高。 

### 1.1.2开源的特征

中国开源软件推进联盟于2016年归纳提出的（已被国际认可）开源特征包括：开放、创新、自由、共享、协同、绿色、民主（化）。开源的本质在于开放、共享、协同。

* 开放指开放标准、开放环境、开放源码；
* 创新是主轴；
* 自由指自由发布、自由传播、自由复制、自由修改、自由使用，其中，自由传播是开源运动的要义；
* 共享指共享资源；
* 协同指协同开发、协同作业、协作生产；
* 绿色指支持绿色可再生能源、绿色环境和零边际成本效应；
* 民主化指在新兴协同共享中，创新和创造力的民主化正在孵化一种新的激励机制，这种机制很少基于经济回报，而更多地基于推动人类的经济生活方式，缩小收入差距，实现全球民主化。为避免原创技术的流失，不能单纯限制孵化阶段开源代码的自由传播，可通过开源的商业模式、安全模块、运维举措、生态系统所构筑的屏蔽层来解决。

作为一种创新协作模式，开源已经不仅仅是开放源代码的软件技术开发，还包括更为广泛的开放技术领域及协同创新的理念与机制，总体包括开放科学、开源软件、开源硬件、开源技术、开源文化、开源经济等。“互联网＋基于知识社会的创新 2.0”是开源创新的基础理论（2005年由中国开源软件推进联盟提出，后来获得全球开源界领袖们的确认），与工业 4.0、工业互联网机制相通，与元宇宙（Metaverse）概念相似。利用开源渠道，将高阶社会（知识社会，虚拟化的实验空间）中的技术、管理、资源等要素，作用于低阶社会（现实的工业社会，物理空间）中的业态（生产的、技术的、经济的、社会的），促使其产生0→1的爆发性重构。

### 1.1.3 开源的范畴

时至今天，开源已成为开源软件、开源硬件、开源生态、开源技术、开源社区、开源经济、开源商业模式、开源理念、开源文化、开源教育、开源许可证、开源基金会、开源孵化器、开源数字化治理体系、开源标准等的总称。
	 
## 1.2 世界开源发展简史

世界开源发展史，有三个里程碑时间节点：1970年、1985年、1991年，分别对应UNIX、GNU、Linux的发展。

### 1.2.1 UNIX简史

* 1969年之前，Bell实验室和MIT、GE合作启动开发一个多任务多用户的操作系统Multics，为UNICS操作系统诞生创造条件。
* 1969年，UNIX原型——UNICS（UNiplexed Information and Computing System）诞生。
* 1973年，Dennis Ritchie发明C语言，用C语言将UNICS重写并更名为UNIX，UNIX正式诞生。
* 1969-1977年，UNIX相继推出V1-V6版本，向社会开放源代码。
* 1977年开始进入“后UNIX”时代，UNIX演化为UNIX（闭源，即AT&T-UNIX）和BSD（开源，即BSD-UNIX）。主流的开源BSD操作系统有386BSD、FreeBSD、NetBSD、OpenBSD。	

因此，世界开源的历史始自1970年开启的“前UNIX”，至今52年，开源在事实上已经历了半个世纪的发展历程。

### 1.2.2 GNU简史

GNU系统是一套向上兼容UNIX的完全自由的操作系统。GNU代表“GNU's Not UNIX”。

* 1983年9月27日，Richard Stallman提出了GNU工程的初始声明，意图找回在早期计算机社区中广泛存在的合作精神，通过除去专属软件所有者设置的障碍而使得合作再次成为可能。
* 1984年1月，Richard Stallman从MIT离职并开始编写GNU软件，同年9月开始GNU Emacs的工作。
* 1985年，Richard Stallman发表《GNU宣言》，吸收“前UNIX”和BSD的开源成果，开发推出Emacs等编译器等自由软件（Free Software）。同年10月，自由软件基金会（FSF）正式成立。

“Free Software”中的“Free”关乎自由，而不是价格，是指可以付费或不付费得到GNU软件。一旦得到了软件，便拥有了使用它的四项特定自由。可以自由按照自己的意愿运行该软件；可以自由复制软件并将其送给朋友和同事；可以自由通过对源代码的完全控制而改进程序；可以自由发布改进的版本从而帮助社区建设。

### 1.2.3 Linux简史

Linux的诞生、发展和成长过程始终依赖着五个重要支柱：UNIX操作系统、MINIX操作系统、GNU计划、POSIX标准和Internet网络。

* 1977年，UNIX的重要分支——BSD在UC Berkeley诞生。开发者是SUN公司创办者Bill Joy。
* 1984年，Andrew S. Tanenbaum为能续进行学术教育研究，重新开发了一个基于“前UNIX”和BSD4.3的开放源代码操作系统——Minix，这是Linux最开始的前身。
* 1985年，GNU开源计划和FSF基金会成立。在这个时间前后，涌现了很多重要的软件和协议，如GPL协议、GCC C编译器、Emacs编辑器、Glibc、bash shell等，为Linux后来的发展创造了肥沃的土壤。
* 1991年，芬兰本科生Linus Torvalds在Minix和GNU成果的基础上，开发并以GNU GPL许可方式发布了开放源代码操作系统Linux v0.01。
* 1992年1月5日，Linux v0.12 release 版本的内核重新以GNU GPL的协议发布。原来的许可证是禁止任何商业用途的。通过这次协议变更，发布和出售Linux成为可能。5月21日 , Peter MacDonald发布第一个独立的Linux安装包SLS。
* 1993年6月17日，Slackware Linux由Patrick Volkerding发布，这是第一个取得广泛成功的Linux发行版。8月16日 ,Ian Murdock（Debian中的“ian”）发布了第一个Debian Linux发行版。Debian是最有影响力的Linux发行版之一，是MEPIS、Mint、Ubuntu等的鼻祖。8月19日 ，Matt Welsh写的《Linux Installation and Getting Started》第1版出版，这是第一本关于Linux的书籍。
* 1994年3月14日 ，Linux内核V1.0发布，它支持基于i386单处理器的计算机系统。8月15日 , William R. Della Croce, Jr.申请了“Linux”商标，9月进行了注册。11月3日，Red Hat共同创始人Marc Ewing宣布可以以49.95美元的零售价格获得Red Hat Software Linux的CD-ROM和30天的安装支持。
* 1996年5月9日 ，吉祥物Tux诞生（见图2）。6月9日，Linux内核V2.0发布，这是第一个在单系统中支持多处理器的稳定内核版本。Linux从此成为很多公司的重要选择。10月14日 ，Mattias Ettrich发起KDE项目，此前UNIX和Linux都没有统一的桌面系统，编写桌面软件非常复杂。

![](https://img-blog.csdnimg.cn/addff322f8754f3c9324942d5496dc22.png)<br/>*Linux的吉祥物Tux*

* 1997年1月9日 ，第一个“Linux病毒”Bliss被发现。
* 1998年5月1日，基于Linux的Google搜索引擎面世。12月4日 ，IDC报告称1998年Linux出货量至少上升200%，以其他任何操作系统无法企及的速度增长着。
* 1999年3月3日，GNOME桌面系统进入Linux世界。
* 2000年2月4日，IDC报告表明Linux排在“最受欢迎的服务器操作系统的第2位”。10月30日 ，第一个Linux live发行版Knoppix发布。
* 2001年1月，Linux 2.4发布，进一步提升了SMP系统的扩展性，同时集成了很多用于支持桌面系统的特性：USB、PC卡（PCMCIA）的支持，内置的即插即用等功能。
* 2003年3月6日，SCO Group公司宣布正在发起对IBM高达10亿美元的诉讼，声称IBM把SCO的商业机密整合到了Linux中。12月，Linux 2.6版内核发布。
* 2007年8月8日，Linux基金会由开源发展实验室（OSDL）和自由标准组织（FSG）联合成立，得到了主要的Linux和开源公司，包括富士通、HP、IBM、Intel、NEC、Oracle、Qualcomm、三星以及开发者的支持。11月5日，Google发布Android，被称为“第一个真正开放的综合移动设备平台”。
* 2011年5月11日 ，Google I/O大会发布基于Linux内核的云操作系统Chrome OS的Chromebook。6月21日，Linus Torvalds发布Linux3.0版本。

### 1.2.4 开源基金会崛起

开源基金会是开源生态中的重要部分。对于非营利性且处于中立位置的开源基金会来说，他们拥有开源项目的知识产权，而且没有任何商业利益，这为贡献者、开发者、用户提供了良好的协作平台；基金会也会通过技术服务和项目孵化来帮助开发者和开源企业，如软件仓库、问题跟踪、技术指导、法律支持、项目投资、公共关系维护等；基金会还会提供项目日常的运营和治理，以满足在项目生命周期不同阶段对于管理项目的需求。

自20世纪80年代自由软件基金会（FSF）开始，全球各类开源基金会快速发展，在构建全球开源生态中发挥着巨大的促进作用，据不完全统计，各类开源基金会已经超过100家，其中具有代表性的包括Apache软件基金会（1999年成立）、Mozilla基金会（2003年成立）、Linux基金会（2007年成立）、云原生计算基金会（2015年成立）、开放原子开源基金会（2020年成立）等。更多基金会的详细介绍参见5.1.1章节。

## 1.3 中国开源发展简史

1991年，中国与AT&T Bell Laboratories USL/USG合作，引进UNIX SVR 4.2版本源代码（全球唯一，但属于“后UNIX”闭源时期），并发布了中文版本，合作组建了中国UNIX公司；中方同时也引进“前UNIX”开放的源代码。

1999年，中科红旗、中软网络、冲浪平台在引进Red Hat公司Linux发行版的基础上，分别推出最早的Linux中文版本。

因此，中国开源的发展历史具有两个里程碑节点：1991年、1999年，至今31年、23年，可以分为启蒙、萌芽、发展、加速四个时代。

### 1.3.1 启蒙时代

1991年，陆首群、张克治和杨天行牵头代表中方代表团与美国AT&T USG合作，美方将最新开发的UNIX版本——UNIX SVR4.2源代码向中方开放。中方为此组织了UNIX新版本编辑委员会，由杨芙清、胡道元、仲萃豪、刘锦德、尤晋元、贾耀良、孙玉芳等国内资深软件专家组成，并邀集全国软件专家、程序员200多人，翻译、编辑、出版了UNIX SVR4.2中文版本共19册，首发式在人民大会堂举行，向全国各大图书馆、高等院校赠书，业界影响甚大。这一历史事件被Linux基金会收录，后被作为中国开源诞生的标志性事件。1991年成为中国开源元年。

1992年12月，中方与USG合资在华成立了中国UNIX公司。

1994年，已经在芬兰工作5年的宫敏博士第一次将Linux和大量自由/开源软件源码通过磁带带回中国。

1997年，宫敏第二次带回80GB的自由软件，并在国家信息中心的帮助下在![中国经济信息网](https://www.cei.gov.cn/)上建成了“中国自由软件库”，为国内技术人员了解、学习和使用Linux及相关自由/开源软件提供了便利。

1998年，在开源概念提出的这一年，在湖南长沙读博士的章文嵩在Linux2.0内核上利用课余时间开发了Linux虚拟服务系统（LVS），并在第一时间开源，在全世界引起很大反响。同一年，在北京清华大学读研的魏永明，决定开发针对实时嵌入式系统的图形界面系统并将其开源，MiniGui应运而生。同一年，在安徽合肥读大二的自动化系学生吴峰光开始接触Linux，他发现Linux的文件预读算法磁盘I/O性能较差，便尝试对Linux内核进行改进。

1998年初，北京冲浪平台软件技术有限公司成立，专注于研发Linux中文发行版，同年9月XteamLinux收获了第一个市场用户——北京市政府政策研究室。1999年3月正式对外发布XteamLinux中文版1.0。2001年冲浪平台在香港创业板上市。

### 1.3.2 萌芽时代

在历时8年的启蒙阶段中，自由/开源软件的理念和文化开始在中国大地生根发芽，随着UNIX、Linux在中国用户的激增，以及互联网时代的到来，中国自发地涌现出一批开源社区和开源企业。在中国开源发展的萌芽阶段，Linux技术的快速普及起到了核心的推动作用。

1999年9月，蓝点软件技术（深圳）有限公司成立，次年3月在美国纳斯达克上市。一个中国初创公司从成立到在美上市仅用不足200天，且上市当天股价暴涨400余倍，这个神话旷古绝今。

1999年底，时任中国科学院软件所副所长的孙玉芳老师牵头筹建北京中科红旗软件有限公司和北京红旗中文贰仟有限公司，分别基于Linux和OpenOffice进行中文版红旗Linux和RedOffice的研制。孙玉芳老师英年早逝，一生发表操作系统相关论文180余篇，编著和译著操作系统原理相关著作140余册，他指导过的诸多硕士/博士生现已成为开源产业的中坚力量。

1999年，中国开发者社区CSDN在蒋涛的努力下成立了，并于2000年创办《程序员》杂志（后于2021年升级为《新程序员》）。

2000年2月，在科技部国家高技术研究发展计划（863计划）的支持下，由一批国内高校、研究院所、IT企业联合发起成立了共创软件联盟。共创软件联盟在开源许可证规则下对863计划的软件成果进行开源培育和孵化，并提出以开放源代码的协同创新模式作为中国基础软件发展的主要路径，对我国开源产业发展起到了重要的推动作用。

2002年，黄建忠以CJacker的ID在中国Linux公社发布了基于Redhat8再发布的Magic Linux版本——这是国内第一个Linux社区发行版。在这个阶段，部分中国开发者开始尝试向国际上游社区贡献代码。但同时，国内Linux企业对开源技术采用拿来主义，忽视开源社区、商业模式和开源知识产权等方面的投入和积累，导致在国际社区中出现了许多针对中国Linux发行商只是开源使用者的评价，直到2008年，这种印象才得以扭转。

2004年，中国开源软件推进联盟成立，陆首群教授被推举为联盟主席，在陆首群主席的大力推进下，为推动开源在中国的发展而不懈努力，也启动了中国与日本、韩国以至全球在发展开源的方面国际合作。联盟的国际智囊团聘请了几十位全球顶级开源专家以多种形式参与和推进中国开源建设，如此规模的智囊团在全球首屈一指，是开源界公认的顶级智库。可以说，联盟的成立和陆主席的领导加速了中国开源软件发展的速度，为碎片化的国内开源产业建立了统一的根据地，为国际开源生态和中国开源生态建立了纽带。

2008年，以Kernel、Apache、GNOME、OpenOffice为代表的国际知名开源社区纷纷选择在北京召开全球技术峰会，作为他们进入亚洲的第一步（之前从未在亚洲国家召开顶级技术峰会）。这是对中国开发者在社区提交贡献的肯定。因此，我们认为2008年成了中国开源发展重要的分水岭。

### 1.3.3 发展时代

在2009年前，中国常被视为国际开源资源单纯的使用者，2009年之后，中国开发者提交的代码被Linux基金会接受，排名稳居世界前四（Kernel 2.6.27之后），中国开始成为国际开源资源的贡献者。

在2009年之后，伴随着云计算、物联网、大数据、移动互联网的快速发展，中国一批有实力有抱负的知名科技IT企业、互联网公司开始选择拥抱开源。Linux基金会执行董事Jim Zemlin曾表示：“这些中国科技公司无论从开源技术上，还是产业、经济发展上，已经走进世界领导者行列。”

在2009-2018年，中国开源呈现了百花齐放的繁荣局面，从开源开发者数量的激增，到开源社区的多样化（不再局限Linux等操作系统领域），再到知名科技企业自内而外的拥抱开源（内部实行开源治理，逐渐对外捐献开源项目，并向上游技术社区提交贡献）。2012年成立的中国开源云联盟（COSCL）和2016年成立的云计算开源产业联盟（OSCAR）就是典型的开源与云计算技术融合的产业联盟。这一阶段明显的特点在于不论是初创企业还是千百亿体量的科技巨头纷纷用开源技术来构建公司自身的技术堆栈，在技术上全面拥抱开源，并越来越重视对上游开源社区和开源基金会的投入与贡献。

### 1.3.4 加速时代

2019年至今，中国开源进入了一个新的时代一一加速阶段。

根据Linux基金会有关Kernel.org社区贡献的统计，来自中国开发者的贡献已居全世界之首（Kernel 4.14至今）。中国开源发展进入深水区，开源生态的完整性、开源社区的成熟性、开源商业模式的多样性和复合性都在发生巨大变化。

由木兰开源社区牵头、多家单位联合参与起草的“中国第一个开源协议——木兰许可证”已经正式发布，前不久还被OSGJ翻译为日文版使用。由华为、百度、腾讯、360、浪潮等发起成立的开放原子开源基金会填补了中国没有开源基金会的空白，尽管它还不能与Linux基金会、Apache软件基金会相提并论，但在开源领域备受瞩目。

在现阶段，部分领先的中国企业不满足于拥抱开源，他们正在很多创新领域跃跃欲试，希望通过开模式来对创新技术进行引领，如商汤的OpenMMLab计算机视觉开放算法、矩阵元的Rosetta隐私Al开源框架、阿里的RocketMQ海量信息中间件、京东的JD Chain开源区块链、百度的PaddlePaddle深度学习平台和Apollo自动驾驶平台、海尔卡奥斯COSMOPlat工业互联网平台的工业APP开发框架开源项目等。同时，在现阶段出现了一些原生的开源明星项目，如Apache SkyWalking、Apache Echarts、Apache loTDB、TiDB，其中一些优秀的开源项目如TiDB备受资本市场的推崇，创造了全球数据库融资历史新的里程碑。

## 1.4 开源软件与知识产权

至此，我们对开源的定义和发展史有了基本的认识，在继续深入了解之前，有必要关注开源软件与知识产权的知识。

### 1.4.1 软件知识产权的主要内涵

软件知识产权是计算机软件人员对自己的研发成果依法享有的权利。目前国际上对软件知识产权的保护法律还不是很健全，大多数国家都是通过著作权法来保护软件知识产权的，与硬件相关密切的软件设计原理还可以申请专利保护。

* 软件知识产权主要包括著作权、专利权与商标权。
* 著作权指软件的表达(如程序代码、文档等)方面的权利。
* 专利权包括软件的技术设计，如程序设计方案、处理问题的方法、各项有关技术信息等方面的权利。
* 商标权则是指软件的名称标识方面的权利。

软件需要有硬件平台的支撑才可以运行，而在硬件平台上运行的软件基本上是目标码（二进制格式），从而造成软件源码和二进制目标码的分离和割裂，而软件作为通用商品进行销售或分发时主要提供的只是二进制文件，这也成为主流的软件销售和分发方式，并主要通过随软件一起发布的最终用户许可协议（End User License Agreement，EULA）对软件的使用、修改和分享及其他相关事宜作出规定。

EULA指的是一家公司的软件与软件的使用者所达成的协议，是软件应用程序作者或者发布者与应用程序使用者之间的合法合同。EULA一般主要规定用户不可以盗版软件，并没有对用户明确涉及对应软件源代码的处置问题——除非特定情况，销售的二进制形式的软件并不提供对应软件源代码；即使偶有提供，但对用户基于该源代码的复制、修改和二次分发等作了严格限制或者禁止。

针对上述对软件源代码的处置方式，出现了一种开放、协同、共享的软件发展模式——通过开源软件许可证对软件源代码的复制、修改、再分发等权益，对商标、专利、著作权等内容进行进一步规范，这也是对软件知识产权发展的一个重要补充。

### 1.4.2 开源软件许可证

开源许可证就是开源软件使用的许可证。对开源软件许可证的法律界定先前存在一定的争议。在美国，一些法院认为软件许可证是合同（Contract），一些法院则认为是许可（License）。两者的区别在于，许可在传统上是由地产或物主作出的，目的在于允许他人使用自己的地块或物品。因此，它是单方向的，不构成完整的合同，而是作为合同的一个要素，用来和他人交换的条件。

合同和许可之分在美国法上具有重要意义。如果是合同，那么需要适用各州不同的合同法；如果是许可，那么需要适用统一的联邦版权法。此外，合同的违约救济和版权的侵权救济也有诸多不同，比如禁令（行为保全）的适用、判赔额的确定、律师费的分担等。

不过，包括中国在内的大陆法系国家，则普遍认为开源软件许可证构成合同；只不过这种许可合同并非协商得到，而是事先规定好的标准化格式合同。具体来讲，开源许可证是涉及版权、专利、商标等一系列权利义务的格式合同，且自动生效。

法律并没有限定许可证不能包含什么条款，这导致许可证的类型极其繁多、内容也非常自由。据不完全统计，广义上的开源许可证目前有超过200种，即便是OSI批准的许可证目前也多达96种，其中包括由中国主导编制的Mulan Permissive Software License v2 (MulanPSL - 2.0)，全部许可证可参见[链接](https://opensource.org/licenses/alphabetical和https://opensource.org/licenses/category)。

### 1.4.3 国外主流开源许可证解读

**（1）GNU通用公共许可证（GPL）**

GPL通用公共许可证是一个许可证家族的泛称，是一个被广泛使用的自由软件许可协议条款，为使用者提供了足够的复制、分发、修改的权利：

* 可自由复制；
* 可自由分发，提供他人下载；
* 可用来盈利，分发软件过程中收费（必须在收费前向客户提供该软件的GNU GPL许可协议）；
* 可自由地修改（使用了这段代码的项目也必须使用GPL协议）。

GPL当前主要有GPL v2和GPL v3两个版本。这组许可证的共同特征在于其“传染性”：任何基于GPL代码编写的软件都必须成为开源软件。换言之，使用了任何GPL代码的软件，无论GPL代码占比多少，都必须将完整的源代码公开，并允许他人修改、发布。

GPLv2许可证存在一些漏洞，例如它不能阻止一个软硬件结合的系统中，通过对硬件部分施加限制，间接阻止用户在该硬件上运行软件的修改版本；没有包括关于专利的约定，导致实践中出现Microsoft-Novell专利协议这类试图将专利申请用作于对付自由软件社群的武器的现象。

为解决这些问题，GPL v3于2007年发布。除填补上述漏洞，GPL v3兼容性更好。自由软件基金会明确表示GPL v3与Apache 2.0 许可证兼容。

目前，使用GPL许可证的重要项目包括Linux内核和MySQL等，但新兴项目一般会选用更宽松的许可证。

**（2）LGPL（Lesser General Public License）**

LGPL叫做GNU宽通用公共协议，对产品所保留的权利比GPL少，适用于非开源产品的开源类库或框架，并可以不继承LGPL协议，使用其他的开源协议。

LGPL的特点在于，链接到该软件库的软件可以不适用LGPL或GPL，换言之，可以不公开源代码。LGPL的这一特性消除了在GPL下软件商用的最大障碍。尽管如此，基于该库修改而得到的软件仍然需要遵循GPL许可证。

**（3）Mozilla Public License（MPL）**

MPL允许在其授权下的源代码与其他授权的文件进行混合，包括私有许可证。在MPL授权下的代码文件必须保持MPL授权，并且保持开源，即允许在派生项目中存在私有模块，同时保证核心文件的开源。使用MPL授权的软件并不受专利的限制，其可以自由使用、修改，并可自由的重新发布。带有专利代码的版本仍然可以使用、转让，甚至出售。

**（4）BSD许可证系列**

BSD许可证是由UC Berkeley首倡和维护的，版本繁多，目前常用版本包括原始的BSD-4、BSD-3以及简化的BSD-2。BSD属于宽松许可证，与MIT许可证接近但更加宽松，甚至跟公有领域更为接近。在最简化的BSD-2许可证下，保留著作权声明、许可证内容以及免责声明即可；只要满足许可证设定的条件，就可以自由地修改并发布代码。

BSD-3许可证在BSD-2许可证的基础上增加了禁止背书条款（未经事先书面许可不得使用原作者之名来推广衍生作品）；BSD许可证进一步增加了广告条款（衍生作品的广告材料必须说明该软件包含由UC Berkeley及其贡献者开发的软件）。

**（5）MIT许可证**

MIT许可证之名源自首倡者MIT麻省理工学院，又称“X许可协议”（X License）或“X11许可协议”（X11 License）。

据统计，2015 年GitHub上高达45%的项目使用MIT许可证。近几年MIT许可证的份额有所下滑，在2020年市场份额第一的位置被Apache 2.0取代，但仍是最受开发者欢迎的许可证之一。

MIT的特点在于条款非常简单，是开源协议中最宽松的一个：“被许可人有权利使用、复制、修改、合并、出版发行、散布、再许可和/或贩售软件及软件的副本，及授予被供应人同等权利”，加上要求被许可人保持同样的声明。

**（6）Apache许可证**

Apache许可证是一种“宽松”（Permissive）的许可证，目前常用版本是2.0，2020年成为使用最多的许可证。“宽松”是指不保证被使用软件的派生版会继续保持自由软件的形式，即：“怎么用都行，用在哪都行”。

具体而言，Apache 2.0许可要求保留版权和许可声明，但允许许可作品、修改和更大的作品在不同的条款和没有源代码的情况下分发，只是未修改的部分仍然需要保留Apache许可证。除了为用户提供版权许可之外，还有专利许可，对于那些涉及专利内容的开发者而言，该协议最适合。

由于上述利好条件，Apache 2.0成为了相当多流行的开源项目的许可证，最著名的例子之一就是Kubernetes。

不同开源许可证就许可、条件和限制的比较参见[链接](https://choosealicense.com/appendix/)。常见开源许可证的对比汇总见表1。

![](https://img-blog.csdnimg.cn/2f3dbcc832b244199a2ba00ba9b99ed9.png)<br/>*表1 常见开源许可证的对比汇总*

可以看出，除了允许商业性使用、分发和修改外等常见特征外，开源许可证还有两个共同点。一是开发者不承担保证责任（瑕疵担保责任）。开源代码通常都是免费提供的，因此开发者不应为他人使用该软件造成的损失而承担责任。二是要求保留著作权标记。开源软件并不意味着放弃著作权。相反，开源许可证的强制效力来源，恰恰来自于作者对开源软件的著作权。

因此，许可证一般都要求以适当的形式保留著作权标记（包括许可证正文以及作者署名）。

### 1.4.4 木兰开源许可证解读

木兰许可证族由中国电子标准化研究院牵头研制，已发布版本包含木兰宽松许可证（MulanPSL v1；MulanPSL v2）、木兰公共许可证（MulanPubL v1；MulanPubL v2）、木兰-白玉兰开放数据许可协议（MBODL v1）。

**木兰宽松许可证（MulanPSL）**

MulanPSL v2于2020年通过OSI认证，是全球首个由我国主导的国际通用中英文双语许可证，与Apache 2.0许可证有良好的兼容性，最大限度鼓励专利和版权开放，并于2021年发布日文版。截止2020年底，已有超过1万余项国内自主开源项目支持MulanPSL 2.0，得到Linux基金会、Apache基金会、华为、阿里、开源中国、CSDN等开源组织、公司和代码托管平台的支持应用，1万7千余代码仓应用（Gitee 11000+，Github 7000+）。其中典型应用有OpenEuler、OpenGauss、方舟编译器、XiOUS等。木兰宽松许可证与国外主流许可证的异同见图3。

![](https://img-blog.csdnimg.cn/d806392891da4d55ac82a866e467da85.png)<br/>*图3 木兰宽松许可证与国外主流许可证的异同*

**木兰公共许可证（MulanPubL）**

木兰公共许可证在宽松版基础上增加了其传染性，对开源软件的分发增加了限制性要求。木兰公共许可证和木兰宽松许可证间存在较大差异，均以第2 版为例，其差别集中在“分发限制”上。木兰公共许可证类似GPL具有传染性，要求接受者必须开放源代码。而木兰宽松许可证的“分发限制”中仅仅要求保留代码中的许可证声明，并未要求再次分发时的许可证设置，不具有“传染”特质。

木兰宽松许可证与木兰公共许可证的共同特点是：采用中英文表述，且具有同等法律效力；遵从表述简洁原则，容易理解；明确授予版权和专利权，不授予商标权。而区别在于前者能与现有的其他许可证友好兼容，后者对开源软件的分发条件有限制性要求，对云计算和SaaS等新兴技术的分发也有条件限制。木兰公关许可证与国外主流许可证的异同见图4。
	
![](https://img-blog.csdnimg.cn/64980ffc1f16487695282334f7631c53.png)<br/>*图4 木兰公共许可证与国外主流许可证对分发的限制*
 
### 1.4.5 开源许可证的选用逻辑

选择开源许可证时，可以从三层阶梯的五个问题入手（见图5）：他人修改代码后，是否可以闭源；新增代码是否采用同样许可证；是否需要对源码的修改之处，提供说明文档；每一个修改过的文件，是否都必须放置版权说明；衍生软件的广告是否可以用你的名字促销。

![](https://img-blog.csdnimg.cn/64f07a711bde45e7ab0f564b1b8792eb.png)<br/>*图5 开源许可证选用逻辑*
